/*
 * Created on Apr 29, 2005 
 *
 */
package com.punosmusic.pitchdistributor;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @author Nick Didkovsky, didkovn@mail.rockefeller.edu
 *  
 */
public class PitchNodeTestApplet extends java.applet.Applet implements ActionListener {

    private PitchNodeCanvas canvas;
    private PitchNodeSystem pitchNodeSystem;
    private Button newTestButton;
    private Button genButton;
    private Label messageLabel;

    public void init() {
    }

    public void start() {
        pitchNodeSystem = new PitchNodeSystem();
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add(newTestButton = new Button("new test"));
        p.add(genButton = new Button("gen"));
        p.add(messageLabel = new Label("--------------------------------------------------------------------"));
        add(BorderLayout.NORTH, p);
        newTestButton.addActionListener(this);
        genButton.addActionListener(this);

        add(BorderLayout.SOUTH, canvas = new PitchNodeCanvas(pitchNodeSystem));
        canvas.setSize(1000, 200);

        newTest();
    }

    private void newTest() {
        PitchNode.setMinPitch(1200 - 600);
        PitchNode.setMaxPitch(2400 + 600);
        PitchNode.setTranspositionForceThreshold(4);	// play with this value. It is the threshold a pitch node needs to exceed in order to transpose itself

        pitchNodeSystem.clear(); // remove all pitches
        for (int i = 0; i < 20; i++) {
            int randomPitch = (int) (Math.random() * 1200 + 1200);
            pitchNodeSystem.addPitchNode(new PitchNode(randomPitch));
        }
        // important! Call init() after you have finished adding all pitches to system. It
        // calculates the first generation of forces
        pitchNodeSystem.init();
        canvas.repaint();
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == genButton) {
            gen();
        }
        if (source == newTestButton) {
            newTest();
        }

    }

    private void gen() {
        boolean stateChanged = pitchNodeSystem.gen();
        double totalForce = pitchNodeSystem.getTotalForce();
        if (stateChanged) {
            messageLabel.setText("Pitches changed state, total force = " + totalForce);
        } else {
            messageLabel.setText("Pitches did not change state, total force = " + totalForce);
        }
        canvas.repaint();
    }
}

/** graph pitches in system. Each pixel = 4 cents */

class PitchNodeCanvas extends Canvas {

    private PitchNodeSystem pitchNodeSystem;

    public PitchNodeCanvas(PitchNodeSystem pitchNodeSystem) {
        this.pitchNodeSystem = pitchNodeSystem;
    }

    public void paint(Graphics g) {
        System.out.println("canvas paint");
        g.setColor(new Color(255, 255, 255));
        g.drawRect(0, 0, getWidth(), getHeight());
        g.setColor(new Color(200, 0, 0));
        g.drawLine((int)PitchNode.getMaxPitch() / 4, 0, (int)PitchNode.getMaxPitch() / 4, 200);
        g.drawLine((int)PitchNode.getMinPitch() / 4, 0, (int)PitchNode.getMinPitch() / 4, 200);
        g.setColor(new Color(0, 0, 50));
        for (int i = 0; i < pitchNodeSystem.size(); i++) {
            PitchNode pn = pitchNodeSystem.getPitchNode(i);
            int x = pn.getPitch() / 4; // scale this 4:1
            double force = pn.getForce();
            //            System.out.println("drawing line at x=" + x + ", force =" + force);
            g.drawLine(x, 0, x, 200);
        }
    }
}